-- change directory to program location
parse source  . . pgm
call directory filespec('L', pgm)

-- define the source file and import it
source=.bsf~new("java.io.File", "01-new doc.pdf")
importdoc=BSF.loadClass("org.apache.pdfbox.Loader")
doc=importdoc~loadPDF(source)
page=doc~getPage(0)

-- set the append mode
contclass = "org.apache.pdfbox.pdmodel.PDPageContentStream"
append=BSF.loadClass(contclass)~AppendMode~APPEND

-- create a content stream
cont=.bsf~new(contclass,doc,page,append,"true")
fontclass = "org.apache.pdfbox.pdmodel.font.Standard14Fonts"
fname = BSF.loadClass(fontclass)~FontName~HELVETICA_BOLD
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)

-- use the content stream to insert content
cont~beginText
cont~setFont(font, 22)
cont~setLeading(25f)
cont~newLineAtOffset( 100, 600 )
cont~showText("Hello World, again")
cont~endText
cont~close

-- save and close the document file
doc~save("02-modified doc.pdf")
doc~close


-- get java support
::requires "BSF.CLS"